<?php
// +----------------------------------------------------------------------
// | 月梦网络软件系统 [ DM299 ]
// +----------------------------------------------------------------------
// | 版权所有 2021~2025 月梦网络 [ http://www.dm299.com ]
// +----------------------------------------------------------------------
// | 官方网站：http://dm299.com
// +----------------------------------------------------------------------
// | 开源协议 ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | 作者: 周志华 <124861234@qq.com>
// +----------------------------------------------------------------------

namespace plugins\Hello\model;

use \Base\Model;
use \Base\Lists;
use \Base\Message;

/**
 * 后台插件模型
 */
class Hello extends Lists 
{
    // 设置当前模型对应的完整数据表名称
	protected static $tableName ="ym_plugin_hello";

    // 模型操作的唯一值
	protected static $onlyId ="id";

	/**
     * 数据表字段
     * @param string $actions 行为名称
     * @author 周志华 <124861234@qq.com>
     * @return bool
     */
    public static function tableInfo()
    {
		return [
				[	'field'=>'id',
					'list'=>['title'=>'ID',		'width'=>80,   'hide'=>1,'fixed'=>'left','sort'=>1]
				],
				[	'field'=>'name',
					'list'=>['title'=>'标题',	'width'=>200,  'sort'=>0,'edit'=>'text'],
					'form'=>['title'=>'标题','type'=>'text','placeholder'=>'请输入标题名称','verify' =>'required','store_range'=>250]
				],
				[	'field'=>'said',
					'list'=>['title'=>'内容',	'sort'=>1]  ,
					'form'=>['title'=>'内容','type'=>'textarea','placeholder'=>'请输入内容','store_range'=>500]
				],
				[	'field'=>'status',			'default'=>1,
					'list'=>['title'=>'状态',	'width'=>110,	'sort'=>1, 'align'=> 'center','templet'=> '#tpl-status'],
					'form'=>['title'=>'状态','type'=>'radio','options'=>[[0,'禁用'],[1,'启用']]]
				]
		];
    }

	/**
     * 数据表配置
     * @param string $actions 行为名称
     * @author 周志华 <124861234@qq.com>
     * @return bool
     */
    public static function tableConfig()
    {
		return [
			'order'  =>'desc',
			'field'  =>'id',
			'sql'	 =>['where'=>'1','field'=>'','left'=>''],
			'search' =>[
					[['type'=>'text','name'=>'keyword','value'=>'','placeholder'=>'请输入名称/描述','width'=>'200'],['format'=>'strip_tags','field'=>['name','said'],'link'=>'like']]
				],
		];
    }

	/**
     * TABLE列表配置
     * @param string $actions 行为名称
     * @author 周志华 <124861234@qq.com>
     * @return bool
     */
    public static function tableLists()
    {
		return [
			'width' => 150, 
			'title' => '行为列表',
			'blockquote'=>'这是一个插件管理演示 ',
			'api' => [
				'lists'		=>[url('admin/plugin/manage?name=hello&pc=admin&pa=lists')],					    // 列表数据的接口
				'edit'		=>[url('admin/plugin/manage?name=hello&pc=admin&pa=add'),'open',array('title'=>'编辑')],
				'add'		=>[url('admin/plugin/manage?name=hello&pc=admin&pa=add'),'open',array('title'=>'增加','checked'=>0)],
				'status'	=>[url('admin/plugin/manage?name=hello&pc=admin&pa=status')],						// 状态替换  tpl
				'del'		=>[url('admin/plugin/manage?name=hello&pc=admin&pa=del'),'confirm','确定要删除吗？'],		    // 删除		 toolbar  button
				'enable'	=>[url('admin/plugin/manage?name=hello&pc=admin&pa=enable'),'confirm','确定要全部启用吗？'],	// 启用		 toolbar
				'disable'	=>[url('admin/plugin/manage?name=hello&pc=admin&pa=disable'),'confirm','确定要全部禁用吗？'],	// 禁用		 toolbar
				'fieldedit' =>[url('admin/plugin/manage?name=hello&pc=admin&pa=edit')],	// 单元格编辑
			],
			'button' => [
				['value'=>'编辑',	'event'=>'edit',	'class'=>''],
				['value'=>'删除',	'event'=>'del',		'class'=>'layui-btn-danger'],
			],
			'toolbar' => [
				['value'=>'<i class="fa fa-plus-circle"></i> 增加',		'event'=>'add',	'class'=>''],
				['value'=>'<i class="fa fa-check-circle-o"></i> 启用',  'event'=>'enable',	'class'=>'layui-btn-normal'],
				['value'=>'<i class="fa fa-ban"></i> 禁用',				'event'=>'disable',	'class'=>'layui-btn-warm'],
				['value'=>'<i class="fa fa-times-circle-o"></i> 删除',  'event'=>'del',		'class'=>'layui-btn-danger'],
			],
			'tpl' => [
				['id'=>'tpl-status','tpl'=>'<input type="checkbox"  lay-skin="switch" lay-text="开启|关闭" data-name="status" value="{{ d.id }}" {{ d.status =="1" ? "checked" : "" }}>']
			],
		];
    }

}
